<?LassoScript

	library('library.lasso');
	
	date_setformat('%Q');
	
	// Lookup
	define_tag('salestax_lookup', -required='zip');

		local('database') = 'salestax_lookup';
		local('table') = 'zip4rates';
		
		local('base') = string_replaceregexp(#zip, -find='.*([0-9]{5}).*', -replace='\\1');
		local('four') = string_replaceregexp(#zip - #base, -find='.*([0-9]{4}).*', -replace='\\1');
		
		local('output') = map('status'='Unknown', 'zip'=#base, 'four'=#four, 'code'='', 'rate'=0.0, 'state'=0.0, 'local'=0.0, 'start'=date(0), 'end'=date(0));
		inline(-search, -database=#database, -table=#table, -op='eq', 'zip'=#base);
			records;
				if(integer(#four) != 0 && integer(field('plus4_low')) <= #four && integer(field('plus4_low')) <= #four);
					#output = map('status'='Match', 'zip'=field('zip'), 'four'=#four, 'code'=field('code'), 'rate'=decimal(field('tot_rate')), 'state'=decimal(field('state')), 'local'=decimal(field('local')), 'start'=date(field('eff_start')), 'end'=date(field('eff_end')));
					loop_abort;
				else(integer(field('plus4_low')) == 0);
					#output = map('status'='Default', 'zip'=field('zip'), 'four'=#four, 'code'=field('code'), 'rate'=decimal(field('tot_rate')), 'state'=decimal(field('state')), 'local'=decimal(field('local')), 'start'=date(field('eff_start')), 'end'=date(field('eff_end')));
				/if;
			/records;
		/inline;
		
		return(@#output);
	/define_tag;
	
	// Import
	define_tag('salestax_import', -required='file');
		
		local('database') = 'salestax_lookup';
		local('table') = 'zip4rates';
		
		auth_admin;

		// Create SQLite database and table
		// Give ANYUSER search permission
		application_initialize('salestax_lookup', '1.0', array(
				-bootstrap='lasso_internal',
				-database=pair(#database=array(
						-table=pair(#table=array(
								-sql='CREATE TABLE ' + #table + ' (ID INTEGER PRIMARY KEY, \
										zip TEXT, \
										plus4_low TEXT, \
										plus4_high TEXT, \
										code TEXT, \
										state TEXT, \
										local TEXT, \
										tot_rate TEXT, \
										eff_start TEXT, \
										eff_end TEXT); \
										CREATE INDEX zip_index ON zip4rates (zip);',
								-group=pair('ANYUSER'='I,S'))),
						-group=pair('ANYUSER'='I,S')))));
		
		local('data') = file_read(#file);
		fail_if(#data == '', file_currenterror(-errorcode), file_currenterror);
		
		local('import' = #data->split(#data >> '\r\n' ? '\r\n' | (#data >> '\r' ? '\r' | '\n')))
		#import->removeall('');

		inline(-database=#database, -table=#table, -sql='DELETE FROM ' + #table); 
		/inline;

		local('sql') = 'BEGIN TRANSACTION;';
		iterate(#import, local('temp'));
			#sql += 'INSERT INTO ' + #table + ' (zip,plus4_low,plus4_high,code,state,local,tot_rate,eff_start,eff_end) VALUES (' + #temp + ');';
			if(#sql->size > 1048576 || #import->size == loop_count);
				#sql += 'COMMIT TRANSACTION;';
				inline(-database=#database, -table=#table, -sql=#sql); 
				/inline;
				#sql = 'BEGIN TRANSACTION;';
			/if;
		/iterate;
	
	/define_tag;
	
?><html>
	<head>
		<title>Washington Sales Tax Lookup Tool</title>
	</head>
	<body>
		<h1>Washington Sales Tax Lookup Tool</h1>
		
		<p>This file defines a zip+4 sales tax lookup tool for Lasso.  The tool allows
		the ZIP4RATES - Consolidated tax rates table to be downloaded from the Washington Department of 
		Revenue Web site periodically.</p>
		
		<h2>Look Up Tax Rate</h2>
		
		<p>Use the form below to look up the tax rate based on the currently loaded
		tax tables.</p>
		
		<form action="[Response_FilePath]" method="post">
			Zip Code 
			<input type="text" name="zip" value="[action_param('zip')]" />
			<input type="submit" name="action" value="Look Up" />
		</form>
		
		[if(action_param('zip') != '')]
			[var('info') = salestax_lookup(action_param('zip'))]
			<p>Tax Rate: <b>[decimal($info->find('rate'))]</b></p>
			<p>Status: [encode_html($info->find('status'))]
			<br />State Rate: [decimal($info->find('state'))]
			<br />Local Rate: [decimal($info->find('local'))]
			<br />Location Code: [integer($info->find('code'))]
			<br />Effective: [encode_html($info->find('start'))] to [encode_html($info->find('end'))]</p>
		[/if]

		<h2>[noprocess][SalesTax_Lookup][/noprocess]</h2>

		<p>[noprocess][SalesTax_Lookup(-zip='zip+4')][/noprocess]</p>
		
		<p>The [noprocess][SalesTax_Lookup][/noprocess] tag requires
		a zip+4 code, 98001-1234, which is used to look up the effective destination sales tax
		rate from the ZIP4RATES - Consolidated table.</p>

		<h2>Import Tax Tables</h2>
		
		<p>Use the link below to fetch the new tax tables from a URL. If
		an error is returned then the new URL should be looked up on the
		<a href="http://www.dor.wa.gov/">Washington Department of
		Revenue</a> site.  The file should be downloaded, unzipped, and
		then uploaded through the form.</p>
		
		<p>The URL of the tax tables available when this file was written
		is specified here and automatically updated two weeks prior to each
		new quarter.</p>  
		
		<?LassoScript
			// Advance date two weeks
			var('date') = date->add(-week=2) &;
			var('year') = $date->format('%y'); // 2-digit year
			var('qrtr') = ($date->month / 3) + 1; // 1-digit quarter
			var('url') = 'http://dor.wa.gov/downloads/Add_Data/ZIP4Q' + $qrtr + $year + 'C.zip';
		?>
		<p><a href="[var: 'url']">[var: 'url']</a></p>
		
		<form action="[Response_FilePath]" method="post" enctype="multipart/form-data">
			Tax Table 
			<input type="file" name="url" value="" />
			<input type="submit" name="action" value="Import" />
		</form>

		[if(action_param('action') >> 'import' && file_uploads->size > 0)]
			[iterate(file_uploads, var('file'))]
				[salestax_import(-file=$file->find('path'))]
			[/iterate]
		[/if]
	
	</body>
</html>