﻿<?LassoScript

	// RSS Data Source and Parser
	// Version 2.1
	//
	// From the Tip of the Week (update of an earlier tip)
	// <http://www.lassosoft.com/Documentation/TotW/index.lasso?9337>
	// <http://www.lassosoft.com/Documentation/TotW/index.lasso?9334>
	// 
	// Based on the RSS 2.0.1 specification
	// <http://cyber.law.harvard.edu/rss/rss.html>
	//
	// Installation - Place this file in Lasso Startup and restart the
	// site or Lasso Service. It is not necessary to set up a host in
	// Lasso Administration. 
	//
	// Changes - Added a "Mozilla" user agent (FMS 2008-11-21).
	//
	//
	// RSS Data Source 
	//
	// Specify the host as -Host=Array(-Datasource='rss_datasource'). 
	// The -Database should name the URL of an RSS feed.  The -Table
	// defaults to showing the items from the RSS feed or can be set to
	// 'channel', 'image', 'cloud', or 'textinput' to show meta
	// information from the feed. The data source automatically caches
	// each RSS feed so it is only fetched once per page.
	// 
	//	[Inline(-Search,
	//			-Host=Array(-datasource='rss_datasource'),
	//			-Database='http://www.listsearch.com/lasso/rss.lasso')]
	//		[Inline(-Search, -Table='image')]
	//			<a href="[field: 'link']">
	//				<img src="[Field('url')]" align="right" width="[Field('width')]" height="[Field('height')]" border="0" />
	//			</a>
	//		[/Inline]
	//		[Inline(-Search, -Table='channel')]
	//			<a href="[Field('link')]"><h2>[Field('title')]</h2></a>[Field('description')]<hr />
	//		[/Inline]
	//		[Records]
	//			<a href="[Field: 'link']">[Field('title')]</a><br />[Field('pubdate')]<br />[Field('description')]<hr />
	//		[/Records]
	//	[/Inline]
	//
	// Search parameters are only recognized on the default 'items'
	// table. All of the standard Lasso operators are supported
	// including bw, cn, eq, ew, gt, gte, lt, lte, nbw, ncn, neq, new,
	// nrx.  All comparisons are handled as strings except for pubDate. 
	// To do a comparison on pubDate the value should be a date object. 
	// An equals comparison against NULL can be used to return items
	// which have any value in the specified field.  A single -Sortfield
	// and -Sort order can be specified.  -MaxRecords and -SkipRecords
	// can also be specified.  Logical operators are not supported, an
	// AND operator is always used.
	//
	// 
	// [RSS_Parser]
	//
	// The type expects a -Host parameter which specifies the URL of an
	// RSS feed and accepts optional -Username, -Password, and -Port.
	// The RSS feed is downloaded and parsed. [RSS_Parser->Items]
	// returns an array of maps for each item in the feed. 
	// [RSS_Parser->Channel] returns a map with the meta-information
	// about the channel.  [RSS_Parser->Image] returns a map with the
	// parameters of an image if one is included. [RSS_Parser->Cloud]
	// and [RSS->Parser->TextInput] are also available. 
	// [RSS_Parser->Fields] returns an array of all the field names that
	// are used in the items in the RSS feed.
	//	
	//	
	
	//
	// RSS Data Source
	//
	// This type is never called directly, but defines the tags
	// necessary to implement a data source.
	//
	define_type('rss_datasource');
	
		// 
		// Databasenames
		//
		// Returns a list of known feed names.
		// 
		define_tag('databasenames');
			!var_defined('__rss_datasource__') ? var('__rss_datasource__') = map;
			return($__rss_datasource__->keys);
		/define_tag;
	
		// 
		// Tablenames
		//
		// Returns a list of table names for the current feed.
		// 
		define_tag('tablenames',
				-required='database');
			return(array('channel','image','cloud','textInput','items'));
		/define_tag;
	
		// 
		// Info
		//
		// Returns an array of field information for the current feed.
		// 
		define_tag('info',
				-required='database',
				-required='table');

			fail_if(#database->beginswith('http') == false, -1, 'The URL of the RSS data source must be specified as the database name');

			!var_defined('__rss_datasource__') ? var('__rss_datasource__') = map;
			$__rss_datasource__ !>> #database ? $__rss_datasource__->insert(#database = rss_parser(-host=#database));
			local('rss') = @$__rss_datasource__->find(#database);

			local('fields') = array;
			select(#table);
				case('channel');
					#fields = #rss->channel->keys;
				case('image');
					#fields = #rss->image->keys;
				case('cloud');
					#fields = #rss->cloud->keys;
				case('textInput');
					#fields = #rss->textinput->keys;
				case;
					#fields = #rss->fields(-params=action_params);
			/select;
			iterate(#fields, local('key'));
				#key = array(#key, false, 'text', false);
			/iterate;
			return(@#fields);
		/define_tag;
	
		// 
		// Action
		//
		// Processes a data source action.  This data source always
		// assumes a -Search.
		// 
		define_tag('action');

			local('database') = database_name;
			local('table') = table_name;

			fail_if(#database->beginswith('http') == false, -1, 'The URL of the RSS data source must be specified as the database name');

			!var_defined('__rss_datasource__') ? var('__rss_datasource__') = map;
			$__rss_datasource__ !>> #database ? $__rss_datasource__->insert(#database = rss_parser(-host=#database));
			local('rss') = @$__rss_datasource__->find(#database);

			local('info' = Self->info(-database=database_name, -table=table_name));
			action_addinfo(#info);

			select(#table);
				case('channel');
					local('record') = array;
					iterate(#info, local('key'));
						#record->insert(#rss->'channel'->find(#key->first));
					/iterate;
					action_addrecord(#record);
					action_setfoundcount(1);
					action_settotalcount(1);
				case('image');
					local('record') = array;
					iterate(#info, local('key'));
						#record->insert(#rss->'image'->find(#key->first));
					/iterate;
					action_addrecord(#record);
					action_setfoundcount(1);
					action_settotalcount(1);
				case('cloud');
					local('record') = array;
					iterate(#info, local('key'));
						#record->insert(#rss->'cloud'->find(#key->first));
					/iterate;
					action_addrecord(#record);
					action_setfoundcount(1);
					action_settotalcount(1);
				case('textInput');
					local('record') = array;
					iterate(#info->keys, local('key'));
						#record->insert(#rss->'textInput'->find(#key->first));
					/iterate;
					action_addrecord(#record);
					action_setfoundcount(1);
					action_settotalcount(1);
				case;
					local('items') = #rss->items(-params=action_params);
					iterate(#items, local('item'));
						local('record') = array;
						iterate(#info, local('key'));
							#record->insert(#item->find(#key->first));
						/iterate;
						action_addrecord(#record);
					/iterate;
					action_setfoundcount(#items->size);
					action_settotalcount(#items->size);
			/select;

		/define_tag;
		
	/define_type;

	//
	// [RSS_Parser]
	//
	// Requires a -Host parameter which specifies the URL of the RSS feed to be parsed.
	// Also accepts optional -Username, -Password, and -Port.
	//
	define_type('rss_parser');
	
		local('params');
		local('data');
		local('xml');
		local('channel');
		local('image');
		local('textinput');
		local('cloud');
		local('items');
		local('fields');
		local('filter');
		local('fitems'); // Filtered items
	
		define_tag('onCreate',
				-required='host',
				-optional='port',
				-optional='username',
				-optional='password');
			fail_if(!local_defined('host'), -1, 'RSS Datasource -Host=\'http://www.example.com/rss.lasso\' is required.');
			self->'params' = params;
			local('params') = array(#host);
			local_defined('port') ? #params->insert(-port=#port);
			local_defined('username') ? #params->insert(-username=#username);
			local_defined('password') ? #params->insert(-password=#password);
			// Send Mozilla User-Agent
			#params->insert(-sendmimeheaders=array('Accept' = "*/*", 'User-Agent'="Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; MS-RTC LM 8)"));           
			self->'data' = \include_url->run(-params=#params);
			self->'xml' = xml(self->'data');
			self->'filter' = array;
		/define_tag;
		
		//
		// [RSS_Parser->Channel]
		//
		// Returns a map of the channel meta-information.
		//
		define_tag('channel');
			self->'channel'->size > 0 ? return(self->'channel');
			self->'channel' = map;
			iterate(self->'xml'->extract('//channel/*'), local('temp'));
				local('name') = #temp->name;
				local('contents') = #temp->contents->trim &;
				if(#name == 'item' || #name == 'image');
					loop_continue;
				else;
					self->'channel'->insert(#name = #contents);
				/if;
			/iterate;
			return(self->'channel');
		/define_tag;
		
		//
		// [RSS_Parser->Image]
		//
		// Returns a map of the optional image meta-information.
		//
		define_tag('image');
			self->'image'->size > 0 ? return(self->'image');
			self->'image' = map;
			iterate(self->'xml'->extract('//image/*'), local('temp'));
				local('name') = #temp->name;
				local('contents') = #temp->contents->trim &;
				if(#name == 'item' || #name == 'image');
					loop_continue;
				else;
					self->'image'->insert(#name = #contents);
				/if;
			/iterate;
			return(self->'image');
		/define_tag;
		
		//
		// [RSS_Parser->TextInput]
		//
		// Returns a map of the optional textinput meta-information.
		//
		define_tag('textinput');
			self->'textinput'->size > 0 ? return(self->'textinput');
			self->'textinput' = map;
			iterate(self->'xml'->extract('//textInput/*'), local('temp'));
				local('name') = #temp->name;
				local('contents') = #temp->contents->trim &;
				if(#name == 'item' || #name == 'image');
					loop_continue;
				else;
					self->'textinput'->insert(#name = #contents);
				/if;
			/iterate;
			return(self->'textinput');
		/define_tag;
		
		//
		// [RSS_Parser->Cloud]
		//
		// Returns a map of the optional cloud meta-information.
		//
		define_tag('cloud');
			self->'cloud'->size > 0 ? return(self->'cloud');
			self->'cloud' = map;
			iterate(self->'xml'->extract('//cloud/*'), local('item'));
				iterate(#item->attributes, local('attr'));
					self->'cloud'->insert(#attr->first = #attr->second->trim &);
				/iterate;
			/iterate;
			return(self->'cloud');
		/define_tag;
		
		//
		// [RSS_Parser->Items]
		//
		// Returns an array of all the items in the RSS feed. Each item
		// is a map.  Accepts optional search parameters like an inline.
		// Supports -Op='bw|cn|eq|ew|nbw|ncn|neq|new|nrx|rx', -ReturnField
		// -SortField and -SortOrder, -MaxRecords and -SkipRecords.
		//
		define_tag('items');
			if(self->'items'->size <= 0);
				self->'items' = array;
				iterate(self->'xml'->(extract: '//item'), local('child'));
					local('item') = map;
					iterate(#child->children, local('temp'));
						local('name') = #temp->name;
						local('contents') = #temp->contents->trim &;
						if(#name >> 'date' && valid_date(#contents));
							#item->insert(#name = date(#contents));
						else(#name == 'category' || #name == 'enclosure' || #name == 'guid' || #name == 'source');
							iterate(#temp->attributes, local('attr'));
								#item->insert(#name + '_' + #attr->first = #attr->second->trim &);
							/iterate;
							#item->insert(#name = date(#contents));
						else;
							#item->insert(#name = #contents);
						/if;
					/iterate;
					self->'items'->insert(#item);
				/iterate;
			/if;
			local('_params') = (local_defined('params') ? #params | params);
			if((self->'fitems' !== null) && (self->'filter' == #_params));
				return(self->'fitems');
			else(#_params->size > 0);
				self->'fitems' = self->'items';
				self->'filter' = #_params;
				// Parameters
				local('_max') = ((#_params >> -maxrecords) ? integer(#_params->find(-maxrecords)->first->second) | self->'items'->size);
				local('_skip') = ((#_params >> -skiprecords) ? integer(#_params->find(-skiprecords)->first->second) | 0);
				local('_sort') = ((#_params >> -sortfield) ? string(#_params->find(-sortfield)->first->second) | '');
				local('_order') = ((#_params >> -sortorder) ? string(#_params->find(-sortorder)->first->second) | 'asc');
				local('_return') = (#_params->find(-returnfield));
				// Handle search parameters using filter.
				local('_op' = 'bw');
				iterate(#_params, local('_param'));
					if(#_param->isa('pair') && (#_param == -op || #_param == -operator));
						local('_op' = #_param->second);
					else(#_param->isa('pair') && (!#_param->first->beginswith('-')));
						self->filter(-field=#_param->first, -op=#_op, -value=#_param->second);
						local('_op' = 'bw');
					/if;
				/iterate;
				// Handle -SortField and -SortOrder
				if(#_sort != '');
					local('sort_array') = array;
					iterate(self->'fitems', local('_temp'));
						#sort_array->insert(#_temp->find(#_sort) = loop_count);
					/iterate;
					#sort_array->removeall(null);
					#sort_array->sort(#_order >> 'asc');
					local('gitems') = array;
					iterate(#sort_array, local('_temp'));
						#gitems->insert(self->'fitems'->get(#_temp->second));
					/iterate;
					self->'fitems' = @#gitems;
				/if;
				// Handle -SkipRecords and -MaxRecords
				if((#_max < self->'fitems'->size) || (#_skip > 0));
					local('hitems') = array;
					#hitems->merge(self->'fitems', 1, #_skip+1, #_max);
					self->'fitems' = @#hitems;
				/if;
				// Handle -ReturnField by knocking out all other field names.
				if(#_return->size > 0);
					iterate(#_return, local('_temp'));
						#_temp->isa('pair') ? #_temp = #_temp->second;
					/iterate;
					iterate(self->'fitems', local('_temp'));
						iterate(#_temp->keys, local('_key'));
							#_return !>> #_key ? #_temp->remove(#_key);
						/iterate;
					/iterate;
				/if;
				return(self->'fitems');
			/if;
			return(self->'items');
		/define_tag;
		
		//
		// [RSS_Parser->Fields]
		//
		// Returns an array of all the field names used in the RSS
		// feed's items.
		//
		define_tag('fields');
			self->'fields'->size > 0 ? return(self->'fields');
			self->'fields' = array;
			local('fields') = set;
			iterate(self->items(-params=(local_defined('params') ? #params | params)), local('item'));
				#fields->insertfrom(#item->keys->iterator);
			/iterate;
			self->'fields'->insertfrom(#fields->iterator):
			return(self->'fields');
		/define_tag;
		
		//
		// [RSS_Parser->Filter]
		//
		// Applies a single filter to the current 'items' array.  The
		// filter consists of a field name, operator, and value.  Only
		// items which match the filter will be kept.  This tag is
		// called internally by the ->Items tag to handle search
		// parameters.  Operator can be 'bw|cn|eq|ew|nbw|ncn|neq|new|nrx|rx'.  
		// Note that other inline parameters are handled by ->Items.
		//
		define_tag('filter',
				-required='field',
				-required='op',
				-required='value');
			self->'fitems' === null ? self->'fitems' = self->'items';
			self->'fitems'->size == 0 ? return;
			loop(-from=self->'fitems'->size, -to=1, -by=-1);
				local('keep') = true;
				if(#op == 'eq' || #op == -eq);
					#value === null
							? #keep = self->'fitems' >> #field
							| #keep = self->'fitems'->get(loop_count)->find(#field) == #value;
				else(#op == 'neq' || #op == -neq);
					#value === null
							? #keep = self->'fitems' !>> #field
							| #keep = self->'fitems'->get(loop_count)->find(#field) != #value;
				else(#op == 'bw' || #op == -bw);
					#keep = string(self->'fitems'->get(loop_count)->find(#field))->beginswith(#value);
				else(#op == 'cn' || #op == -cn);
					#keep = string(self->'fitems'->get(loop_count)->find(#field)) >> #value;
				else(#op == 'ew' || #op == -ew);
					#keep = string(self->'fitems'->get(loop_count)->find(#field))->endswith(#value);
				else(#op == 'rx' || #op == -rx);
					#keep = string_findregexp(self->'fitems'->get(loop_count)->find(#field), -find=#value)->size > 0;
				else(#op == 'nbw' || #op == -nbw);
					#keep = !string(self->'fitems'->get(loop_count)->find(#field))->beginswith(#value);
				else(#op == 'ncn' || #op == -ncn);
					#keep = string(self->'fitems'->get(loop_count)->find(#field)) !>> #value;
				else(#op == 'new' || #op == -new);
					#keep = !string(self->'fitems'->get(loop_count)->find(#field))->endswith(#value);
				else(#op == 'nrx' || #op == -nrx);
					#keep = string_findregexp(self->'fitems'->get(loop_count)->find(#field), -find=#value)->size == 0;
				else(#op == 'lt' || #op == -lt);
					#keep = self->'fitems'->get(loop_count)->find(#field) < #value;
				else(#op == 'lte' || #op == -lte);
					#keep = self->'fitems'->get(loop_count)->find(#field) <= #value;
				else(#op == 'gt' || #op == -gt);
					#keep = self->'fitems'->get(loop_count)->find(#field) > #value;
				else(#op == 'gte' || #op == -gte);
					#keep = self->'fitems'->get(loop_count)->find(#field) >= #value;
				/if;
				#keep == false ? self->'fitems'->remove(loop_count);
			/loop;
		/define_tag;

	/define_type;

	// 
	// Register the RSS data source.
	//
	datasource_register('rss_datasource');

?>