﻿<?LassoScript

	//	JQuery.Newsticker.Lasso
	//
	//	Copyright 2007 by LassoSoft, LLC
	//
	//	This file defines The [JQuery_Newsticker] custom tag which 
	//	automatically creates a newsticker from an array of headlines.
	// 
	//	The required JQuery plug-in can be found here:
	//
	//	http://www.texotela.co.uk/code/jquery/newsticker/
	//
	//	See this tip of the week for descriptions of the custom tags
	//	defined in this file.
	//
	//	http://www.lassosoft.com/Documentation/TotW/index.lasso?9302

	include_once: '/jquery/jquery.lasso';
	
	// [JQuery_NewsTicker]
	//
	// 
	define_tag: 'jquery_newsticker', -required='headlines', -optional='delay', -optional='background', -optional='border', -optional='padding', -optional='margin', -optional='width', -optional='height';

		jquery_install;
		jquery_addscript: '/jquery/jquery.newsticker.pack.js';

		local: 'id' = 'jquery_newsticker_' + lasso_uniqueid;
		
		jquery_addready: '$("#' + #id + '").newsticker(' + (local: 'delay') + ');';

		local: 'style' = '';
		#style += '#' + #id + ' {';
		#style += 'list-style-type: none;';
		#style += 'border: ' + ((local_defined: 'border') ? #border | '1px dashed #000000') + '; ';
		#style += 'background: ' + ((local_defined: 'background') ? #background | '#ffffff') + '; ';
		#style += 'padding: ' + ((local_defined: 'padding') ? #padding | '3px') + '; ';
		#style += 'margin: ' + ((local_defined: 'margin') ? #margin | '0px') + '; ';
		(local_defined: 'width') ? #style += 'width: ' + #width + '; ';
		(local_defined: 'height') ? #style += 'height: ' + #height + '; ';
		#style += '} ';
		jquery_addcss: #style;
		
		local: 'output' = '';
		#output += '<ul id="' + #id + '">';
		iterate: #headlines, (local: 'temp');
			#output += '<li>' + #temp + '</li>';
		/iterate;
		#output += '</ul>';
		return: @#output;
	/define_tag;
?>
