﻿<?LassoScript

	//
	//	[Inline_Helper]
	//
	//	Copyright 2007 LassoSoft, LLC
	//
	//	Originally published in the following Tip of the Week
	//	http://www.LassoSoft.com/Documentation/TotW/index.lasso?9328
	//
	//	Usage - The [Inline_Helper] tag is a pre-processor for inline
	//	parameters.  It asks Lasso to generate the SQL statement for
	//	the specified parameters and returns a set of parameters which
	//	perform an equivalent -SQL action on the database.
	//
	//	An optional -Comment parameter adds a C-style /* Comment */ to
	//	the start of the SQL statement.  This comment makes it
	//	possible to determine the source of each SQL statement in e.g.
	//	the MySQL slow query log and process list.
	//
	//	The technique used by this tag could be used to perform more
	//	radical modifications to the generated SQL statement.  This
	//	would allow a user to extend Lasso's built-in database
	//	abstraction.
	//
	//	[Inline: (Inline_Helper: -Comment='My Comment',
	//			-Search,
	//			-Database='ldml8_reference',
	//			-Table='tags',
	//			-KeyField='id',
	//			)] ... [/Inline]
	//
	//	SELECT /* My Comment */ * FROM tags;
	//

	Define_Tag: 'helper', -Namespace='inline_';
		
		Local: '_sql' = '';
		Local: '_params' = Params;
		Local: '_action' = Array;
		
		// Action contains the parameters we want to pass back
		// out to the inline.  Merge only the required parameters.
		#_action->(Merge: Params->(Find: -Host));
		#_action->(Merge: Params->(Find: -Database));
		#_action->(Merge: Params->(Find: -Table));
		#_action->(Merge: Params->(Find: -Schema));
		#_action->(Merge: Params->(Find: -KeyField));
		#_action->(Merge: Params->(Find: -Username));
		#_action->(Merge: Params->(Find: -Password));
		#_action->(Merge: Params->(Find: -InlineName));
		#_action->(Merge: Params->(Find: -StatementOnly));
		
		// Special handling for -MaxRecords and -SkipRecords.
		If: #_params >> -UseLimit;
			#_action->(Insert: -MaxRecords='all');
		Else;
			#_action->(Merge: Params->(Find: -MaxRecords));
			#_action->(Merge: Params->(Find: -SkipRecords));
		/If;
		
		// Params contains the parameter we want to pass to the
		// internal inline.  Remove parameters we don't need.
		#_params->(RemoveAll: -InlineName);
		#_params->(RemoveAll: -Comment);

		// Internal inline generates the SQL statement
		Inline: #_params, -StatementOnly;
			#_sql = Action_Statement;
		/Inline;

		// Add the comment to the SQL statement.
		If: (Local_Defined: 'comment') && (#_sql !>> '/*') && (#_sql >> 'SELECT' || #_sql >> 'UPDATE' || #_sql >> 'DELETE');
			#_sql = (String_ReplaceRegexp: #_sql, -Find='\\w+ ', -Replace='\\0 /* ' + #comment + ' */ ', -IgnoreCase, -ReplaceOnlyOne);
		/If;
		
		// Insert the SQL statement into the action and return.
		#_action->(Insert: -SQL=#_sql);
		Return: @#_action;
	
	/Define_Tag;

?>
